class AttrDict(dict):
    def __getattr__(self, attr):
        if attr in self:
            return self[attr]
        else:
            raise AttributeError("neither exists an attribute nor a key called '%s'." % attr)


def attrdicttest():
    d = AttrDict(a = 5, get = 6)
    print d.a
    print d.get
    print d.baba




def lowerFuncs(base, *names):
    def lowerFunc(clsname, bases, classDict):
        for name in names:
            print 'Name', name
            def comparator(self, other, *args, **kwargs):
                print 'Inner name', name
                print getattr(base, name)
                return getattr(base, name)(self._lower, other.lower(), *args, **kwargs)
            classDict[name] = comparator
        return type(clsname, bases, classDict)
    return lowerFunc

class CIStr(str):
    __metaclass__ = lowerFuncs(str, '__eq__', '__le__', '__lt__', '__ge__', '__gt__')
    
    def __init__(self, *args, **kwargs):
        str.__init__(self, *args, **kwargs)
        # string will never change, so calc once
        self._lower = self.lower()
    def __str__(self):
        return str.__str__(self)
    def __repr__(self):
        return str.__repr__(self)
    def startswith(self, prefix, *args, **kwargs):
        return str.startswith(self._lower, prefix.lower(), *args, **kwargs)
        
if __name__ == "__main__":
    s = CIStr("Baba")
    print s == "baba"
    print s.__eq__('BABA')
   # print s.startswith('bA')
