typedef float point[3];
typedef float vector[3];

vector *something(point *a, point *b, point *c) {
    vector* v1 = make_vector(a, b);
    vector* v2 = make_vector(b, c);
    vector* result = cross_product(v1, v2);

    normalize_vector(result);

    delete[] v1;
    delete[] v2;

    return result;
}

vector *make_vector(point *a, point *b) {
    vector *result = new vector;
    for (int i = 0; i < 3; i++) result[i] = b[i] - a[i];
    return result;
}

vector *cross_product(vector *a, vector *b) {
    vector *result = new vector;
    result[0] = a[1] * b[2] - a[2] * b[1];
    result[1] = a[2] * b[0] - a[0] * b[2];
    result[2] = a[0] * b[1] - a[1] * b[0];
    return result;
}

void normalize_vector(vector *v) {
    float len = sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    for (int i = 0; i < 3; i++) vector[i] /= len;
}

