from __future__ import with_statement
import os
import threading
import time

orders = 0

def log(msg):
	print "* %s" % msg

class Chefs(threading.Thread):
	def __init__(self, order, *args):
		self.order = order
		threading.Thread.__init__(self)
	def run(self):
		time.sleep(3)
		log("Order '%s' is ready!" % self.order)

class SeveralChefs(threading.Thread):
	def __init__(self, order, lock):
		self.order, self.lock = order, lock
		threading.Thread.__init__(self)
	def run(self):
		with self.lock:
			log("Preparing '%s'." % self.order)
			time.sleep(5)
			log("Order '%s' is ready!" % self.order)

LonelyChef = SeveralChefs

def threaded(Chefs=Chefs, lock=None):
	global orders
	while True:
		order = raw_input('Enter order: ')
		if not order: continue
		if order in ('q', 'x', 'quit', 'exit'): break
		chefs = Chef(order, lock)
		chefs.start()
		log("Roger that '%s'. Please, wait in quiet desperation." % order)
		orders += 1



def forked():
	global orders
	while True:
		order = raw_input('Enter order: ')
		if not order: continue
		if order in ('q', 'x', 'quit', 'exit'): break
		pid = os.fork()
		if 0 == pid:
			time.sleep(3)
			log("Order '%s' is ready!" % order)
		else:
			log("Roger that '%s'. Please, wait in quiet desperation." % order)
			orders += 1

class ProducerBaba(threading.Thread):
	producers = 0
	banitsas = 0
	def __init__(self, queue, condition):
		self.queue, self.condition = queue, condition
		self.name = 'Baba %d' % ProducerBaba.producers
		ProducerBaba.producers += 1
		threading.Thread.__init__(self, name=self.name)
	def run(self):
		while True:
			with self.condition:
				self.queue.append(ProducerBaba.banitsas)
				print "Banitsa %d produced by %s" % (ProducerBaba.banitsas, self.name)
				ProducerBaba.banitsas += 1
				self.condition.notify()
			time.sleep(1)
	
class ConsumerGrandson(threading.Thread):
	grandsons = 0
	def __init__(self, queue, condition):
		self.queue, self.condition = queue, condition
		self.name = 'Grandson %d' % ConsumerGrandson.grandsons
		ConsumerGrandson.grandsons += 1
		threading.Thread.__init__(self, name=self.name)
	def run(self):
		while True:
			with self.condition:
				while not self.queue:
					self.condition.wait()
				banitsa = self.queue.pop(0)
				self.condition.notify()	
			print "%s started eating banitsa %s" % (self.name, banitsa)
			time.sleep(3)
			print "Banista %d eaten by %s" % (banitsa, self.name)

def procon():
	condition = threading.Condition()
	ConsumerGrandson(queue, condition).start()
	ConsumerGrandson(queue, condition).start()
	ConsumerGrandson(queue, condition).start()
	ProducerBaba(queue, condition).start()
	ProducerBaba(queue, condition).start()
	

if __name__ == '__main__':
	#forked()
	#threaded()
	#threaded(LonelyChef, threading.Lock())
	#threaded(SeveralChefs, threading.Semaphore(2))
	procon()
